package gov.va.genisis2.dao.impl;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotEquals;
import static org.junit.Assert.assertNotNull;

import java.util.List;

import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.TransactionSystemException;

import gov.va.genisis2.AbstractMockMvcTests;
import gov.va.genisis2.common.enums.WorkflowStatusEnum;
import gov.va.genisis2.dao.IRequestDao;
import gov.va.genisis2.dao.IStudyApprovalDao;
import gov.va.genisis2.exceptions.GenisisDAOException;
import gov.va.genisis2.model.Request;
import gov.va.genisis2.model.RequestHistory;
import gov.va.genisis2.model.StudyApproval;
import gov.va.genisis2.model.WorkflowStatus;

/**
 * The Class RequestDaoTest.
 *
 * @author Getaneh Kassahun
 * 
 *         The Class RequestDaoTest.
 * 
 *         Description: In this RequestDaoTest Class which extends the abstract
 *         class, AbstractMockMvcTests, junit tests are defined.
 */
@FixMethodOrder(MethodSorters.NAME_ASCENDING)
public class RequestDaoTest extends AbstractMockMvcTests {

	/** The LOGGER. */
	private static final Logger logger = LoggerFactory.getLogger(RequestDaoTest.class);

	@Autowired
	private IRequestDao requestDao;

	@Autowired
	private IStudyApprovalDao studyApprovalDao;

	private Request request;

	private RequestDao requestDao_SF_Null;

	/**
	 * Test create request null.
	 * 
	 * @throws GenisisDAOException
	 */
	@Test
	public void testCreateRequest_null1() throws GenisisDAOException {
		// testing when request is null
		logger.info("**********Junit Test Create Request Null**********");
		assertEquals(0, requestDao.createRequest(null));

	}

	/**
	 * Test create request null.
	 * 
	 * @throws GenisisDAOException
	 */
	@Test(expected = GenisisDAOException.class)
	public void testCreateRequest_null2() throws GenisisDAOException {
		// testing when request is null
		logger.info("**********Junit Test Create Request Null**********");
		setSessionFactory_Null();
		requestDao_SF_Null.createRequest(new Request());

	}

	/**
	 * To test create request.
	 * 
	 * @throws GenisisDAOException
	 */
	@Test
	public void testCreateRequest_notNull() throws GenisisDAOException {
		// testing when request are not null
		logger.info("**********Junit Test Create Request Not Null**********");

		request = requestDao.getRequestById(1);
		assertNotEquals(0, requestDao.createRequest(request));

	}

	/**
	 * Test get requests by UID.
	 */
	@Test
	public void testGetRequestsByUID() throws GenisisDAOException {

		logger.info("**********Junit Test Get Requests by uid **********");
		List<Request> requests = requestDao.getRequestsByUID("researcher1");
		assertNotNull(requests);

	}

	/**
	 * Test get requests by UID.
	 */
	@Test(expected = GenisisDAOException.class)
	public void testGetRequestsByUID_null() throws GenisisDAOException {

		logger.info("**********Junit Test Get Requests by uid **********");
		setSessionFactory_Null();
		requestDao_SF_Null.getRequestsByUID("researcher1");

	}

	/**
	 * Test get requests data manager.
	 */
	@Test
	public void testGetRequestsDataManagers() throws GenisisDAOException {

		logger.info("**********Junit Test Get Requests Data Manager**********");

		List<Request> requests = requestDao.getRequestsDataManagers("researcher1");
		assertNotNull(requests);
	}

	/**
	 * Test get requests data manager.
	 */
	@Test(expected = GenisisDAOException.class)
	public void testGetRequestsDataManagers_null() throws GenisisDAOException {

		logger.info("**********Junit Test Get Requests Data Manager**********");
		setSessionFactory_Null();
		requestDao_SF_Null.getRequestsDataManagers("researcher1");
	}

	/**
	 * Test get requests by data manager.
	 */
	@Test
	public void testGetRequestsByDataManagers() throws GenisisDAOException {

		logger.info("**********Junit Test Get Requests By Data Manager**********");

		List<Request> requests = requestDao.getRequestsByDataManager("researcher1");
		assertNotNull(requests);
	}

	/**
	 * Test get requests by data manager.
	 */
	@Test(expected = GenisisDAOException.class)
	public void testGetRequestsByDataManagers_null() throws GenisisDAOException {

		logger.info("**********Junit Test Get Requests By Data Manager**********");
		setSessionFactory_Null();
		requestDao_SF_Null.getRequestsByDataManager("researcher1");
	}

	/**
	 * Test get Requests Data Source Managers
	 */
	@Test
	public void testGetRequestsDataSourceManagers() throws GenisisDAOException {

		logger.info("**********Junit Test Get Requests DataSource Managers**********");

		List<Request> requests = requestDao.getRequestsDataSourceManagers("researcher1");
		assertNotNull(requests);
	}

	/**
	 * Test get Requests Data Source Managers
	 */
	@Test(expected = GenisisDAOException.class)
	public void testGetRequestsDataSourceManagers_null() throws GenisisDAOException {

		logger.info("**********Junit Test Get Requests DataSource Managers**********");
		setSessionFactory_Null();
		requestDao_SF_Null.getRequestsDataSourceManagers("researcher1");

	}

	/**
	 * Test get Request By Id
	 */
	@Test
	public void testGetRequestsById() throws GenisisDAOException {

		logger.info("**********Junit Test Get Requests By Id**********");

		Request requests = requestDao.getRequestById(1);
		assertEquals(1, requests.getId());
	}

	@Test(expected = GenisisDAOException.class)
	public void testGetRequestsById_null() throws GenisisDAOException {

		logger.info("**********Junit Test Get Requests By Id**********");
		setSessionFactory_Null();
		requestDao_SF_Null.getRequestById(1);
	}

	/**
	 * Test get All Requests.
	 */
	@Test
	public void testGetAllRequests() throws GenisisDAOException {

		logger.info("**********Junit Test Get All Requests**********");

		List<Request> requests = requestDao.getAllRequests();
		assertNotNull(requests);
	}

	/**
	 * Test get All Requests.
	 */
	@Test(expected = GenisisDAOException.class)
	public void testGetAllRequests_null() throws GenisisDAOException {

		logger.info("**********Junit Test Get All Requests**********");
		setSessionFactory_Null();
		requestDao_SF_Null.getAllRequests();
	}

	/**
	 * Test get All Requests By Study Approval.
	 */
	@Test
	public void testGetAllRequestsByStudyApproval() throws GenisisDAOException {

		logger.info("**********Junit Test Get All Requests By Study Approval**********");
		StudyApproval studyApproval = studyApprovalDao.getStudyApprovalsByID(176);
		List<Request> requests = requestDao.getAllRequestsByStudyApproval(studyApproval.getId());
		assertNotNull(requests);
	}

	/**
	 * Test get All Requests By Study Approval.
	 */
	@Test(expected = GenisisDAOException.class)
	public void testGetAllRequestsByStudyApproval_null() throws GenisisDAOException {

		logger.info("**********Junit Test Get All Requests By Study Approval**********");
		setSessionFactory_Null();
		requestDao_SF_Null.getAllRequestsByStudyApproval(1);
	}

	/**
	 * Test get All Requests By Staus.
	 */
	@Test
	public void testGetAllRequestsByStaus() throws GenisisDAOException {

		logger.info("**********Junit Test Get All Requests By Staus**********");
		List<Request> requests = requestDao.getAllRequestsByStaus("ResultsNotAccepted");
		assertNotNull(requests);
	}

	/**
	 * Test get All Requests By Staus.
	 */
	@Test(expected = GenisisDAOException.class)
	public void testGetAllRequestsByStaus_null() throws GenisisDAOException {

		logger.info("**********Junit Test Get All Requests By Staus**********");
		setSessionFactory_Null();
		requestDao_SF_Null.getAllRequestsByStaus("ResultsNotAccepted");
	}

	/**
	 * Test SubmitOrModify.
	 */
	@Test
	public void testSubmitOrModify() throws GenisisDAOException {

		logger.info("**********Junit Test SubmitOrModify**********");
		request = requestDao.getRequestById(1);
		assertEquals(1, requestDao.submitOrModify(request));
	}

	/**
	 * Test SubmitOrModify.
	 */
	@Test(expected = TransactionSystemException.class)
	public void testSubmitOrModify_Null() throws GenisisDAOException {

		logger.info("**********Junit Test SubmitOrModify**********");
		requestDao.submitOrModify(new Request());
	}

	/**
	 * Test SubmitOrModify RequestHistory.
	 */
	@Test(expected = GenisisDAOException.class)
	public void test1SubmitOrModifyRequestHistory() throws GenisisDAOException {

		logger.info("**********Junit Test SubmitOrModify RequestHistory**********");
		setSessionFactory_Null();
		requestDao_SF_Null.submitOrModify(new RequestHistory());
	}

	/**
	 * Test SubmitOrModify RequestHistory.
	 */
	@Test
	public void testSubmitOrModifyRequestHistory() throws GenisisDAOException {

		/*
		 * logger.
		 * info("**********Junit Test SubmitOrModify RequestHistory**********");
		 * request = requestDao.getRequestById(1); List<RequestHistory>
		 * requestHistoryList =
		 * requestDao.getRequestHistoriesById(request.getId()); RequestHistory
		 * requestHistory = requestHistoryList.get(0);
		 * requestHistory.setRequest(request);
		 * assertNotNull(requestDao.submitOrModify(requestHistory));
		 */
	}

	/**
	 * Test get RequestHistory By Id.
	 */
	@Test
	public void testGetRequestHistoryById() throws GenisisDAOException {

		logger.info("**********Junit Test Get RequestHistory By Id**********");
		List<RequestHistory> listOfRequestHistory = requestDao.getRequestHistoriesById(1);
		assertNotNull(listOfRequestHistory);
	}

	/**
	 * Test get RequestHistory By Id.
	 */
	@Test(expected = GenisisDAOException.class)
	public void testGetRequestHistoryById_null() throws GenisisDAOException {

		logger.info("**********Junit Test Get RequestHistory By Id**********");
		setSessionFactory_Null();
		requestDao_SF_Null.getRequestHistoriesById(1);
	}

	/**
	 * Test get RequestHistoryByRequestIdAndStatus.
	 */
	@Test
	public void testGetRequestHistoryByRequestIdAndStatus() throws GenisisDAOException {

		logger.info("**********Junit Test Get RequestHistoryByRequestIdAndStatus**********");
		List<RequestHistory> listOfRequestHistory = requestDao.getRequestHistoriesByRequestIdAndStatus(1, "Draft");
		assertNotNull(listOfRequestHistory);
	}

	/**
	 * Test get RequestHistoryByRequestIdAndStatus.
	 */
	@Test(expected = GenisisDAOException.class)
	public void testGetRequestHistoryByRequestIdAndStatus_null() throws GenisisDAOException {

		logger.info("**********Junit Test Get RequestHistoryByRequestIdAndStatus**********");
		setSessionFactory_Null();
		requestDao_SF_Null.getRequestHistoriesByRequestIdAndStatus(1, "Draft");
	}

	/**
	 * Test getRequestHistoriesWithCommentsById.
	 */
	@Test
	public void testGetRequestHistoriesWithCommentsById() throws GenisisDAOException {

		logger.info("**********Junit Test Get RequestHistoriesWithCommentsById**********");
		List<RequestHistory> listOfRequestHistory = requestDao.getRequestHistoriesWithCommentsById(1);
		assertNotNull(listOfRequestHistory);
	}

	/**
	 * Test getRequestHistoriesWithCommentsById.
	 */
	@Test(expected = GenisisDAOException.class)
	public void testGetRequestHistoriesWithCommentsById_null() throws GenisisDAOException {

		logger.info("**********Junit Test Get RequestHistoriesWithCommentsById**********");
		setSessionFactory_Null();
		requestDao_SF_Null.getRequestHistoriesWithCommentsById(1);
	}

	/**
	 * Test getRequestStatusCounts.
	 */
	@Test
	public void testGetRequestStatusCounts() throws GenisisDAOException {

		logger.info("**********Junit Test Get RequestStatusCounts**********");
		List<WorkflowStatus> listOfWorkflowStatus = requestDao.getRequestStatusCounts();
		assertNotNull(listOfWorkflowStatus);
	}

	/**
	 * Test getRequestStatusCounts.
	 */
	@Test(expected = GenisisDAOException.class)
	public void testGetRequestStatusCounts_null() throws GenisisDAOException {

		logger.info("**********Junit Test Get RequestStatusCounts**********");
		setSessionFactory_Null();
		requestDao_SF_Null.getRequestStatusCounts();
	}

	/**
	 * Test getWorkflowStatus.
	 */
	@Test
	public void testGetWorkflowStatus() throws GenisisDAOException {

		logger.info("**********Junit Test Get WorkflowStatus**********");
		WorkflowStatus workflowStatus = requestDao.getWorkflowStatus(WorkflowStatusEnum.CANCELLED.getDesc());
		assertEquals("Cancelled", workflowStatus.getDescription());
	}

	/**
	 * Test getWorkflowStatus.
	 */
	@Test(expected = GenisisDAOException.class)
	public void testtestGetWorkflowStatus_null() throws GenisisDAOException {

		logger.info("**********Junit Test SubmitOrModify RequestHistory**********");

		setSessionFactory_Null();
		requestDao_SF_Null.getWorkflowStatus(WorkflowStatusEnum.CANCELLED.getDesc());

	}

	private void setSessionFactory_Null() {

		requestDao_SF_Null = new RequestDao();
		requestDao_SF_Null.setSessionFactory(null);
	}

}
